/*
 * Decompiled with CFR 0.152.
 */
package taylor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.TextAttribute;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.text.AttributedString;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import taylor.Change;
import taylor.TSEModel;

public class TSEView
extends JPanel
implements ChangeListener {
    private TSEModel model;
    private int tx;
    private int ty;
    private double xres;
    private double yres;
    private int mouseX;
    private int mouseY;

    public TSEView() {
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createEtchedBorder());
        DrawingMouseListener listener = new DrawingMouseListener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.addMouseWheelListener(listener);
        this.addComponentListener(new ComponentAdapter(){
            private int width;
            private int height;
            {
                this.width = TSEView.this.getWidth();
                this.height = TSEView.this.getHeight();
            }

            public void componentResized(ComponentEvent e) {
                if (this.width > 0 && this.height > 0 && TSEView.this.getWidth() > 0 && TSEView.this.getHeight() > 0) {
                    TSEView.this.xres *= 1.0 * (double)TSEView.this.getWidth() / (double)this.width;
                    TSEView.this.yres *= 1.0 * (double)TSEView.this.getHeight() / (double)this.height;
                    TSEView.this.tx = (int)((double)TSEView.this.tx * (1.0 * (double)TSEView.this.getWidth() / (double)this.width));
                    TSEView.this.ty = (int)((double)TSEView.this.ty * (1.0 * (double)TSEView.this.getHeight() / (double)this.height));
                    TSEView.this.repaint();
                }
                this.width = TSEView.this.getWidth();
                this.height = TSEView.this.getHeight();
            }
        });
    }

    public TSEModel getModel() {
        return this.model;
    }

    public void setModel(TSEModel model) {
        if (model != null) {
            if (this.model != null) {
                this.model.removeChangeListener(this);
            }
            this.model = model;
            this.model.addChangeListener(this);
            this.repaint();
        }
    }

    public void centerView() {
        this.xres = (double)this.getWidth() / 10.0;
        this.yres = (double)this.getHeight() / 10.0;
        this.tx = (int)((double)(this.getWidth() / 2) - this.xres * this.model.getPoint());
        this.ty = (int)((double)(this.getHeight() / 2) + this.yres * this.model.evaluateFunction(this.model.getPoint()));
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.model != null) {
            if (!this.model.isLoading()) {
                this.drawAxes(g2);
                g2.setColor(Color.BLUE);
                g2.setStroke(new BasicStroke(1.25f));
                this.plotFunction(g2, false);
                g2.setColor(Color.RED);
                g2.setStroke(new BasicStroke());
                this.plotFunction(g2, true);
            } else {
                AttributedString ats = new AttributedString(ResourceBundle.getBundle("properties/taylor").getString("loadingMessage"));
                ats.addAttribute(TextAttribute.FONT, new Font("Monospaced", 1, 12));
                g2.drawString(ats.getIterator(), this.getWidth() / 2, this.getHeight() / 2);
            }
        }
    }

    private void drawAxes(Graphics2D g2) {
        int i;
        int first;
        int step;
        if (this.ty > 0 && this.ty < this.getHeight()) {
            g2.draw(new Line2D.Float(0.0f, this.ty, this.getWidth(), this.ty));
            step = (int)Math.ceil(100.0 / this.xres);
            first = (int)Math.ceil(this.rx(0));
            first -= first % step;
            i = 0;
            while (this.dx(first + i * step) < (float)this.getWidth()) {
                this.tickX(first + i * step, g2);
                ++i;
            }
        }
        if (this.tx > 0 && this.tx < this.getWidth()) {
            g2.draw(new Line2D.Float(this.tx, 0.0f, this.tx, this.getHeight()));
            step = (int)Math.ceil(100.0 / this.yres);
            first = (int)Math.ceil(this.ry(this.getHeight() - 1));
            first -= first % step;
            i = 0;
            while (this.dy(first + i * step) > 0.0f) {
                this.tickY(first + i * step, g2);
                ++i;
            }
        }
    }

    private void drawMousePosition(Graphics2D g2) {
        g2.drawString("(" + String.format("%.2f", this.rx(this.mouseX)) + "," + String.format("%.2f", this.ry(this.mouseY)) + ")", 4, this.getHeight() - 8);
    }

    private void tickX(int x, Graphics2D g2) {
        g2.draw(new Line2D.Float(this.dx(x), this.ty - 3, this.dx(x), this.ty + 3));
        g2.drawString(String.format("%d", x), this.dx(x) + 2.0f, (float)(this.ty + 12));
    }

    private void tickY(int y, Graphics2D g2) {
        g2.draw(new Line2D.Float(this.tx - 3, this.dy(y), this.tx + 3, this.dy(y)));
        g2.drawString(String.format("%d", y), (float)(this.tx + 2), this.dy(y) + 12.0f);
    }

    private void plotFunction(Graphics2D g2, boolean taylor) {
        GeneralPath p = new GeneralPath();
        p.moveTo(0.0f, taylor ? this.dy(this.model.evaluateSeries(this.rx(0))) : this.dy(this.model.evaluateFunction(this.rx(0))));
        for (int x = 1; x < this.getWidth(); ++x) {
            p.lineTo(x, taylor ? this.dy(this.model.evaluateSeries(this.rx(x))) : this.dy(this.model.evaluateFunction(this.rx(x))));
        }
        g2.draw(p);
    }

    private double rx(int x) {
        return (double)(x - this.tx) / this.xres;
    }

    private float dx(double x) {
        return (float)(this.xres * x + (double)this.tx);
    }

    private double ry(int y) {
        return (double)(-(y - this.ty)) / this.yres;
    }

    private float dy(double y) {
        return (float)(-this.yres * y + (double)this.ty);
    }

    public void stateChanged(ChangeEvent e) {
        if (!this.model.isLoading() && this.model.getLastChange() != Change.TERMS) {
            this.centerView();
        } else {
            this.repaint();
        }
    }

    private class DrawingMouseListener
    extends MouseAdapter
    implements MouseMotionListener,
    MouseWheelListener {
        private int startTx;
        private int startTy;
        private double startXres;
        private double startYres;
        private int startX;
        private int startY;
        private boolean stretching;

        private DrawingMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.startTx = TSEView.this.tx;
            this.startTy = TSEView.this.ty;
            this.startXres = TSEView.this.xres;
            this.startYres = TSEView.this.yres;
            this.startX = e.getX();
            this.startY = e.getY();
            this.stretching = e.isShiftDown();
            TSEView.this.setCursor(Cursor.getPredefinedCursor(13));
        }

        public void mouseReleased(MouseEvent e) {
            TSEView.this.setCursor(Cursor.getDefaultCursor());
        }

        public void mouseDragged(MouseEvent e) {
            if (e.isShiftDown() && this.stretching) {
                TSEView.this.xres = this.startXres * (double)(e.getX() - TSEView.this.tx) / (double)(this.startX - TSEView.this.tx);
                TSEView.this.yres = this.startYres * (double)(e.getY() - TSEView.this.ty) / (double)(this.startY - TSEView.this.ty);
                if (TSEView.this.xres < 1.0) {
                    TSEView.this.xres = 1.0;
                } else if (TSEView.this.xres > 10000.0) {
                    TSEView.this.xres = 10000.0;
                }
                if (TSEView.this.yres < 1.0) {
                    TSEView.this.yres = 1.0;
                } else if (TSEView.this.yres > 10000.0) {
                    TSEView.this.yres = 10000.0;
                }
            } else if (!this.stretching) {
                TSEView.this.tx = this.startTx + (e.getX() - this.startX);
                TSEView.this.ty = this.startTy + (e.getY() - this.startY);
            }
            TSEView.this.mouseX = e.getX();
            TSEView.this.mouseY = e.getY();
            TSEView.this.repaint();
        }

        public void mouseMoved(MouseEvent e) {
            TSEView.this.mouseX = e.getX();
            TSEView.this.mouseY = e.getY();
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            double x = TSEView.this.rx(e.getX());
            double y = TSEView.this.ry(e.getY());
            TSEView.this.xres *= 1.0 - (double)e.getWheelRotation() * 0.05;
            TSEView.this.yres *= 1.0 - (double)e.getWheelRotation() * 0.05;
            if (TSEView.this.xres < 1.0) {
                TSEView.this.xres = 1.0;
            } else if (TSEView.this.xres > 10000.0) {
                TSEView.this.xres = 10000.0;
            }
            if (TSEView.this.yres < 1.0) {
                TSEView.this.yres = 1.0;
            } else if (TSEView.this.yres > 10000.0) {
                TSEView.this.yres = 10000.0;
            }
            TSEView.this.tx -= (int)(TSEView.this.dx(x) - (float)e.getX());
            TSEView.this.ty -= (int)(TSEView.this.dy(y) - (float)e.getY());
            TSEView.this.repaint();
        }
    }
}

