/*
 * Decompiled with CFR 0.152.
 */
package taylor;

import java.util.ResourceBundle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.lsmp.djep.djep.DJep;
import org.lsmp.djep.sjep.PolynomialCreator;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import taylor.Change;

public class TSEModel {
    private final int[][] binom = new int[][]{{1}, {1, 1}, {1, 2, 1}, {1, 3, 3, 1}, {1, 4, 6, 4, 1}, {1, 5, 10, 10, 5, 1}, {1, 6, 15, 20, 15, 6, 1}, {1, 7, 21, 35, 35, 21, 7, 1}, {1, 8, 28, 56, 70, 56, 28, 8, 1}, {1, 9, 36, 84, 126, 126, 84, 36, 9, 1}, {1, 10, 45, 120, 210, 252, 210, 120, 45, 10, 1}, {1, 11, 55, 165, 330, 462, 462, 330, 165, 55, 11, 1}, {1, 12, 66, 220, 495, 792, 924, 792, 495, 220, 66, 12, 1}, {1, 13, 78, 286, 715, 1287, 1716, 1716, 1287, 715, 286, 78, 13, 1}, {1, 14, 91, 364, 1001, 2002, 3003, 3432, 3003, 2002, 1001, 364, 91, 14, 1}, {1, 15, 105, 455, 1365, 3003, 5005, 6435, 6435, 5005, 3003, 1365, 455, 105, 15, 1}};
    private final long[] fac = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L};
    private String function = "sin(x)";
    private double point = 0.0;
    private int terms = 2;
    private Change lastChange;
    private boolean loading;
    private double[] seriesCoeff = new double[this.terms];
    private DJep parser = new DJep();
    private PolynomialCreator pc;
    private String error;
    private EventListenerList ll;

    public TSEModel() {
        this.parser.addStandardConstants();
        this.parser.addStandardFunctions();
        this.parser.setImplicitMul(true);
        this.parser.setAllowUndeclared(true);
        this.parser.addStandardDiffRules();
        this.parser.setAllowUndeclared(false);
        this.parser.addVariable("x", this.point);
        this.parser.parseExpression(this.function);
        this.pc = new PolynomialCreator(this.parser);
        this.ll = new EventListenerList();
        this.fillSeriesCoeff();
        this.lastChange = Change.FUNCTION;
        this.loading = false;
    }

    private void fillSeriesCoeff() {
        try {
            double[] deriv = new double[this.terms];
            this.parser.addVariable("x", this.point);
            Node node = this.parser.parse(this.function);
            for (int term = 0; term < this.terms; ++term) {
                deriv[term] = (Double)this.parser.evaluate(node);
                node = this.pc.simplify(this.parser.differentiate(node, "x"));
            }
            for (int n = 0; n < this.terms; ++n) {
                this.seriesCoeff[n] = 0.0;
                for (int m = n; m < this.terms; ++m) {
                    int n2 = n;
                    this.seriesCoeff[n2] = this.seriesCoeff[n2] + deriv[m] / (double)this.fac[m] * (double)this.binom[m][n] * Math.pow(-this.point, m - n);
                }
            }
        }
        catch (ParseException ex) {
            this.error = this.parser.getErrorInfo();
        }
    }

    public synchronized String getFunction() {
        return this.function;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean setFunction(String function) {
        this.loading = true;
        this.fireStateChanged(new ChangeEvent(this));
        String oldFunction = this.function;
        try {
            this.function = this.parser.toString(this.pc.simplify(this.parser.parse(function)));
            this.parser.parseExpression(this.function);
            this.fillSeriesCoeff();
            this.lastChange = Change.FUNCTION;
            boolean bl = true;
            return bl;
        }
        catch (ParseException e) {
            this.error = ResourceBundle.getBundle("properties/taylor").getString("invalidFunction") + this.parser.getErrorInfo();
            boolean bl = false;
            return bl;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.error = ResourceBundle.getBundle("properties/taylor").getString("cannotUseFunction");
            this.function = oldFunction;
            this.parser.parseExpression(this.function);
            this.fillSeriesCoeff();
            boolean bl = false;
            return bl;
        }
        catch (OutOfMemoryError e) {
            this.error = ResourceBundle.getBundle("properties/taylor").getString("outOfMemory");
            this.terms = 2;
            this.seriesCoeff = new double[this.terms];
            this.fillSeriesCoeff();
            this.lastChange = Change.FUNCTION;
            boolean bl = false;
            return bl;
        }
        finally {
            this.loading = false;
            this.fireStateChanged(new ChangeEvent(this));
        }
    }

    public synchronized double getPoint() {
        return this.point;
    }

    public synchronized void setPoint(double point) {
        this.loading = true;
        this.fireStateChanged(new ChangeEvent(this));
        this.point = point;
        this.fillSeriesCoeff();
        this.lastChange = Change.POINT;
        this.loading = false;
        this.fireStateChanged(new ChangeEvent(this));
    }

    public synchronized int getNumberOfTerms() {
        return this.terms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean setNumberOfTerms(int terms) {
        this.loading = true;
        this.fireStateChanged(new ChangeEvent(this));
        int oldTerms = this.terms;
        try {
            this.terms = terms < 1 ? 1 : (terms > 16 ? 16 : terms);
            this.seriesCoeff = new double[this.terms];
            this.fillSeriesCoeff();
            this.lastChange = Change.TERMS;
            boolean bl = true;
            return bl;
        }
        catch (OutOfMemoryError e) {
            this.error = ResourceBundle.getBundle("properties/taylor").getString("outOfMemory");
            this.terms = oldTerms;
            this.seriesCoeff = new double[this.terms];
            this.fillSeriesCoeff();
            boolean bl = false;
            return bl;
        }
        finally {
            this.loading = false;
            this.fireStateChanged(new ChangeEvent(this));
        }
    }

    public double getSeriesCoeff(int n) {
        return n >= 0 && n < this.terms ? this.seriesCoeff[n] : Double.NaN;
    }

    public synchronized Change getLastChange() {
        return this.lastChange;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public synchronized String getError() {
        return this.error;
    }

    public synchronized double evaluateFunction(double x) {
        this.parser.addVariable("x", x);
        return this.parser.getValue();
    }

    public synchronized double evaluateSeries(double x) {
        double result = this.seriesCoeff[0];
        for (int term = 1; term < this.terms; ++term) {
            result += Math.pow(x, term) * this.seriesCoeff[term];
        }
        return result;
    }

    public void addChangeListener(ChangeListener l) {
        this.ll.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.ll.remove(ChangeListener.class, l);
    }

    public void fireStateChanged(ChangeEvent e) {
        ChangeListener[] listeners;
        for (ChangeListener l : listeners = (ChangeListener[])this.ll.getListeners(ChangeListener.class)) {
            l.stateChanged(e);
        }
    }
}

