/*
 * Decompiled with CFR 0.152.
 */
package taylor;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.nfunk.jep.JEP;
import taylor.TSEModel;
import taylor.TSEView;

public class TSEFrame
extends JFrame
implements ChangeListener {
    private TSEModel model = new TSEModel();
    private JEP jep;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JSpinner jSpinner1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private TSEView tSEView1;

    public TSEFrame() {
        this.model.addChangeListener(this);
        this.jep = new JEP();
        this.jep.setImplicitMul(true);
        this.jep.addStandardConstants();
        this.jep.addStandardFunctions();
        this.initComponents();
        this.tSEView1.centerView();
    }

    private void initComponents() {
        this.tSEView1 = new TSEView();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabel2 = new JLabel();
        this.jSpinner1 = new JSpinner();
        this.jLabel3 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextField3 = new JTextField();
        this.setTitle(ResourceBundle.getBundle("properties/taylor").getString("windowTitle"));
        this.tSEView1.setModel(this.model);
        GroupLayout tSEView1Layout = new GroupLayout(this.tSEView1);
        this.tSEView1.setLayout(tSEView1Layout);
        tSEView1Layout.setHorizontalGroup(tSEView1Layout.createParallelGroup(1).add(0, 406, Short.MAX_VALUE));
        tSEView1Layout.setVerticalGroup(tSEView1Layout.createParallelGroup(1).add(0, 406, Short.MAX_VALUE));
        this.jLabel1.setText(ResourceBundle.getBundle("properties/taylor").getString("pointLabel"));
        this.jTextField1.setColumns(5);
        this.jTextField1.setText("" + this.model.getPoint());
        this.jTextField1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TSEFrame.this.jTextField1ActionPerformed(evt);
            }
        });
        this.jLabel2.setText(ResourceBundle.getBundle("properties/taylor").getString("termsLabel"));
        this.jSpinner1.setModel(new SpinnerNumberModel(this.model.getNumberOfTerms(), 1, 16, 1));
        this.jSpinner1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                TSEFrame.this.jSpinner1StateChanged(evt);
            }
        });
        this.jLabel3.setText(ResourceBundle.getBundle("properties/taylor").getString("functionLabel"));
        this.jTextField2.setForeground(new Color(0, 0, 255));
        this.jTextField2.setText(this.model.getFunction());
        this.jTextField2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TSEFrame.this.jTextField2ActionPerformed(evt);
            }
        });
        this.jLabel4.setText(ResourceBundle.getBundle("properties/taylor").getString("seriesLabel"));
        this.jTextField3.setEditable(false);
        this.jTextField3.setForeground(new Color(255, 0, 0));
        this.jTextField3.setText(this.buildSeries());
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(12, 12, 12).add(layout.createParallelGroup(1).add(2, this.jLabel4).add(2, this.jLabel1).add(2, this.jLabel3)).addPreferredGap(0).add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.jTextField1, -1, 180, Short.MAX_VALUE).addPreferredGap(0).add(this.jLabel2).add(12, 12, 12).add(this.jSpinner1, -2, -1, -2)).add(this.jTextField3, -1, 326, Short.MAX_VALUE).add(this.jTextField2, -1, 326, Short.MAX_VALUE)).addContainerGap()).add(this.tSEView1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().add(this.tSEView1, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel3).add(this.jTextField2, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel4).add(this.jTextField3, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel2).add(this.jSpinner1, -2, -1, -2).add(this.jTextField1, -2, -1, -2).add(this.jLabel1)).addContainerGap()));
        this.pack();
    }

    private void jTextField1ActionPerformed(ActionEvent evt) {
        new Thread(new Runnable(){

            public void run() {
                TSEFrame.this.jep.parseExpression(TSEFrame.this.jTextField1.getText());
                if (!TSEFrame.this.jep.hasError()) {
                    TSEFrame.this.model.setPoint(TSEFrame.this.jep.getValue());
                }
                TSEFrame.this.jTextField1.setText("" + TSEFrame.this.model.getPoint());
            }
        }).start();
    }

    private void jSpinner1StateChanged(ChangeEvent evt) {
        new Thread(new Runnable(){

            public void run() {
                if (!TSEFrame.this.model.setNumberOfTerms((Integer)TSEFrame.this.jSpinner1.getValue())) {
                    TSEFrame.this.showError();
                    TSEFrame.this.jSpinner1.setValue(TSEFrame.this.model.getNumberOfTerms());
                }
            }
        }).start();
    }

    private void jTextField2ActionPerformed(ActionEvent evt) {
        new Thread(new Runnable(){

            public void run() {
                if (!TSEFrame.this.model.setFunction(TSEFrame.this.jTextField2.getText())) {
                    TSEFrame.this.showError();
                }
                TSEFrame.this.jTextField2.setText(TSEFrame.this.model.getFunction());
                TSEFrame.this.jSpinner1.setValue(TSEFrame.this.model.getNumberOfTerms());
            }
        }).start();
    }

    private void showError() {
        JOptionPane.showMessageDialog(this, this.model.getError(), ResourceBundle.getBundle("properties/taylor").getString("errorWindowTitle"), 0);
    }

    private String buildSeries() {
        int i;
        StringBuffer sb = new StringBuffer();
        DecimalFormat df = new DecimalFormat("0.###E0");
        for (i = 0; i < this.model.getNumberOfTerms() && this.model.getSeriesCoeff(i) == 0.0; ++i) {
        }
        if (i == this.model.getNumberOfTerms()) {
            sb.append("0.0");
        } else {
            if (i == 0) {
                sb.append(df.format(this.model.getSeriesCoeff(i)));
            } else {
                sb.append(df.format(this.model.getSeriesCoeff(i)) + " * x^" + i);
            }
            ++i;
            while (i < this.model.getNumberOfTerms()) {
                if (this.model.getSeriesCoeff(i) != 0.0) {
                    sb.append((this.model.getSeriesCoeff(i) > 0.0 ? " +" : " ") + df.format(this.model.getSeriesCoeff(i)) + " * x^" + i);
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public void stateChanged(ChangeEvent e) {
        this.jTextField3.setText(this.buildSeries());
    }

    public static void main(String[] args) {
        TSEFrame frame = new TSEFrame();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

