/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.sjep;

import org.lsmp.djep.sjep.AbstractPNode;
import org.lsmp.djep.sjep.PNodeI;
import org.lsmp.djep.sjep.PolynomialCreator;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.type.Complex;

public class PConstant
extends AbstractPNode {
    Object value;

    public PConstant(PolynomialCreator polynomialCreator, Object object) {
        super(polynomialCreator);
        this.value = object;
    }

    public PNodeI negate() throws ParseException {
        return new PConstant(this.pc, this.pc.neg(this.value));
    }

    public PNodeI add(PNodeI pNodeI) throws ParseException {
        if (this.isZero()) {
            return pNodeI;
        }
        if (pNodeI instanceof PConstant) {
            return new PConstant(this.pc, this.pc.add(this.value, ((PConstant)pNodeI).value));
        }
        return super.add(pNodeI);
    }

    public PNodeI sub(PNodeI pNodeI) throws ParseException {
        if (this.isZero()) {
            return pNodeI.negate();
        }
        if (pNodeI instanceof PConstant) {
            return new PConstant(this.pc, this.pc.sub(this.value, ((PConstant)pNodeI).value));
        }
        return super.sub(pNodeI);
    }

    public PNodeI mul(PNodeI pNodeI) throws ParseException {
        if (this.isZero()) {
            return this.pc.zeroConstant;
        }
        if (this.isOne()) {
            return pNodeI;
        }
        if (pNodeI.isZero()) {
            return this.pc.zeroConstant;
        }
        if (pNodeI.isOne()) {
            return this;
        }
        if (pNodeI instanceof PConstant) {
            return new PConstant(this.pc, this.pc.mul(this.value, ((PConstant)pNodeI).value));
        }
        return super.mul(pNodeI);
    }

    public PNodeI div(PNodeI pNodeI) throws ParseException {
        if (this.isZero()) {
            if (pNodeI.isZero()) {
                return this.pc.nanConstant;
            }
            return this.pc.zeroConstant;
        }
        if (pNodeI.isZero()) {
            return this.pc.infConstant;
        }
        if (pNodeI.isOne()) {
            return this;
        }
        if (pNodeI instanceof PConstant) {
            return new PConstant(this.pc, this.pc.div(this.value, ((PConstant)pNodeI).value));
        }
        return super.div(pNodeI);
    }

    public PNodeI invert() throws ParseException {
        return new PConstant(this.pc, this.pc.div(this.pc.one, this.value));
    }

    public PNodeI pow(PNodeI pNodeI) throws ParseException {
        if (this.isZero()) {
            if (pNodeI.isZero()) {
                return this.pc.nanConstant;
            }
            return this.pc.zeroConstant;
        }
        if (this.isOne()) {
            return this.pc.oneConstant;
        }
        if (pNodeI.isZero()) {
            return this.pc.oneConstant;
        }
        if (pNodeI instanceof PConstant) {
            return new PConstant(this.pc, this.pc.raise(this.value, ((PConstant)pNodeI).value));
        }
        return super.pow(pNodeI);
    }

    public String toString() {
        if (this.isZero()) {
            return "0";
        }
        if (this.isOne()) {
            return "1";
        }
        if (this.isInfinity()) {
            return "inf";
        }
        if (this.isNan()) {
            return "NaN";
        }
        if (this.isInteger()) {
            return String.valueOf(this.intValue());
        }
        return this.value.toString();
    }

    public boolean isZero() {
        return this.value.equals(this.pc.zero);
    }

    public boolean isOne() {
        return this.value.equals(this.pc.one);
    }

    public boolean isMinusOne() {
        return this.value.equals(this.pc.minusOne);
    }

    public boolean isInfinity() {
        if (this.value.equals(this.pc.infinity)) {
            return true;
        }
        if (this.value instanceof Double) {
            return ((Double)this.value).isInfinite();
        }
        if (this.value instanceof Complex) {
            return ((Complex)this.value).isInfinite();
        }
        return false;
    }

    public boolean isNan() {
        if (this.value.equals(this.pc.nan)) {
            return true;
        }
        if (this.value instanceof Double) {
            return ((Double)this.value).isNaN();
        }
        if (this.value instanceof Complex) {
            return ((Complex)this.value).isNaN();
        }
        return false;
    }

    public boolean isPositive() {
        try {
            return ((Double)this.value).compareTo((Double)this.pc.zero) > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isNegative() {
        try {
            return ((Double)this.value).compareTo((Double)this.pc.zero) < 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isInteger() {
        try {
            double d = (Double)this.value;
            return d == Math.floor(d);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int intValue() {
        return ((Number)this.value).intValue();
    }

    public Node toNode() throws ParseException {
        return this.pc.nf.buildConstantNode(this.value);
    }

    public int compareTo(PConstant pConstant) {
        return ((Comparable)this.value).compareTo(pConstant.value);
    }

    public boolean equals(PNodeI pNodeI) {
        if (pNodeI instanceof PConstant) {
            return this.value.equals(((PConstant)pNodeI).value);
        }
        return false;
    }

    public PNodeI expand() {
        return this;
    }
}

