/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.sjep;

import org.lsmp.djep.sjep.AbstractPNode;
import org.lsmp.djep.sjep.MutiableMonomial;
import org.lsmp.djep.sjep.MutiablePolynomial;
import org.lsmp.djep.sjep.PConstant;
import org.lsmp.djep.sjep.PFunction;
import org.lsmp.djep.sjep.PNodeI;
import org.lsmp.djep.sjep.PVariable;
import org.lsmp.djep.sjep.Polynomial;
import org.lsmp.djep.sjep.PolynomialCreator;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class Monomial
extends AbstractPNode {
    PConstant coeff;
    PNodeI[] vars;
    PNodeI[] powers;

    Monomial(PolynomialCreator polynomialCreator, PConstant pConstant, PNodeI[] pNodeIArray, PNodeI[] pNodeIArray2) {
        super(polynomialCreator);
        if (pNodeIArray.length != pNodeIArray2.length) {
            throw new IllegalArgumentException("Monomial.valueOf length of variables and powers must be equal. they are " + pNodeIArray.length + " " + pNodeIArray2.length);
        }
        this.coeff = pConstant;
        this.vars = pNodeIArray;
        this.powers = pNodeIArray2;
    }

    Monomial(PolynomialCreator polynomialCreator, PConstant pConstant, PNodeI pNodeI) {
        super(polynomialCreator);
        this.coeff = pConstant;
        this.vars = new PNodeI[]{pNodeI};
        this.powers = new PNodeI[]{polynomialCreator.oneConstant};
    }

    Monomial(PolynomialCreator polynomialCreator, PConstant pConstant, PNodeI pNodeI, PNodeI pNodeI2) {
        super(polynomialCreator);
        this.coeff = pConstant;
        this.vars = new PNodeI[]{pNodeI};
        this.powers = new PNodeI[]{pNodeI2};
    }

    PNodeI valueOf(PConstant pConstant, PNodeI[] pNodeIArray, PNodeI[] pNodeIArray2) {
        if (pConstant.isZero()) {
            return this.pc.zeroConstant;
        }
        if (pNodeIArray.length == 0) {
            return pConstant;
        }
        return new Monomial(this.pc, pConstant, pNodeIArray, pNodeIArray2);
    }

    MutiableMonomial toMutiableMonomial() {
        PNodeI[] pNodeIArray = new PNodeI[this.vars.length];
        PNodeI[] pNodeIArray2 = new PNodeI[this.vars.length];
        for (int i = 0; i < this.vars.length; ++i) {
            pNodeIArray[i] = this.vars[i];
            pNodeIArray2[i] = this.powers[i];
        }
        return new MutiableMonomial(this.pc, this.coeff, pNodeIArray, pNodeIArray2);
    }

    public PNodeI mul(PNodeI pNodeI) throws ParseException {
        if (pNodeI instanceof PConstant) {
            return this.valueOf((PConstant)this.coeff.mul(pNodeI), this.vars, this.powers);
        }
        if (pNodeI instanceof Monomial) {
            return this.mul((Monomial)pNodeI);
        }
        MutiableMonomial mutiableMonomial = this.toMutiableMonomial();
        mutiableMonomial.mul(pNodeI, this.pc.oneConstant);
        return mutiableMonomial.toPNode();
    }

    public PNodeI div(PNodeI pNodeI) throws ParseException {
        if (pNodeI instanceof PConstant) {
            return this.valueOf((PConstant)this.coeff.div(pNodeI), this.vars, this.powers);
        }
        if (pNodeI instanceof Monomial) {
            return this.div((Monomial)pNodeI);
        }
        MutiableMonomial mutiableMonomial = this.toMutiableMonomial();
        mutiableMonomial.mul(pNodeI, this.pc.minusOneConstant);
        return mutiableMonomial.toPNode();
    }

    PNodeI mul(Monomial monomial) throws ParseException {
        MutiableMonomial mutiableMonomial = this.toMutiableMonomial();
        mutiableMonomial.mul(monomial.coeff);
        for (int i = 0; i < monomial.vars.length; ++i) {
            mutiableMonomial.mul(monomial.vars[i], monomial.powers[i]);
        }
        return mutiableMonomial.toPNode();
    }

    PNodeI div(Monomial monomial) throws ParseException {
        MutiableMonomial mutiableMonomial = this.toMutiableMonomial();
        mutiableMonomial.div(monomial.coeff);
        for (int i = 0; i < this.vars.length; ++i) {
            mutiableMonomial.mul(monomial.vars[i], monomial.powers[i].negate());
        }
        return mutiableMonomial.toPNode();
    }

    public PNodeI pow(PNodeI pNodeI) throws ParseException {
        if (pNodeI instanceof PConstant) {
            MutiableMonomial mutiableMonomial = this.toMutiableMonomial();
            mutiableMonomial.power((PConstant)pNodeI);
            return mutiableMonomial.toPNode();
        }
        return super.pow(pNodeI);
    }

    public PNodeI negate() throws ParseException {
        return new Monomial(this.pc, (PConstant)this.coeff.negate(), this.vars, this.powers);
    }

    public PNodeI invert() throws ParseException {
        PNodeI[] pNodeIArray = new PNodeI[this.vars.length];
        for (int i = 0; i < this.vars.length; ++i) {
            pNodeIArray[i] = this.powers[i].negate();
        }
        return new Monomial(this.pc, (PConstant)this.coeff.invert(), this.vars, pNodeIArray);
    }

    public PNodeI add(PNodeI pNodeI) throws ParseException {
        Monomial monomial;
        if (pNodeI instanceof PVariable && this.equalsIgnoreConstant(pNodeI)) {
            return this.valueOf((PConstant)this.coeff.add(this.pc.oneConstant), this.vars, this.powers);
        }
        if (pNodeI instanceof Monomial && this.equalsIgnoreConstant(monomial = (Monomial)pNodeI)) {
            return this.valueOf((PConstant)this.coeff.add(monomial.coeff), this.vars, this.powers);
        }
        return super.add(pNodeI);
    }

    public PNodeI sub(PNodeI pNodeI) throws ParseException {
        Monomial monomial;
        if (pNodeI instanceof PVariable && this.equalsIgnoreConstant(pNodeI)) {
            return this.valueOf((PConstant)this.coeff.sub(this.pc.oneConstant), this.vars, this.powers);
        }
        if (pNodeI instanceof Monomial && this.equalsIgnoreConstant(monomial = (Monomial)pNodeI)) {
            return this.valueOf((PConstant)this.coeff.sub(monomial.coeff), this.vars, this.powers);
        }
        return super.sub(pNodeI);
    }

    PNodeI addConstant(PConstant pConstant) throws ParseException {
        return this.valueOf((PConstant)this.coeff.add(pConstant), this.vars, this.powers);
    }

    public boolean equals(PNodeI pNodeI) {
        if (!(pNodeI instanceof Monomial)) {
            return false;
        }
        if (!this.coeff.equals(((Monomial)pNodeI).coeff)) {
            return false;
        }
        return this.equalsIgnoreConstant((Monomial)pNodeI);
    }

    boolean equalsIgnoreConstant(Monomial monomial) {
        if (this.vars.length != monomial.vars.length) {
            return false;
        }
        for (int i = 0; i < this.vars.length; ++i) {
            if (!this.vars[i].equals(monomial.vars[i])) {
                return false;
            }
            if (this.powers[i].equals(monomial.powers[i])) continue;
            return false;
        }
        return true;
    }

    boolean equalsIgnoreConstant(PNodeI pNodeI) {
        if (pNodeI instanceof Monomial) {
            return this.equalsIgnoreConstant((Monomial)pNodeI);
        }
        if (this.vars.length != 1) {
            return false;
        }
        if (!this.vars[0].equals(pNodeI)) {
            return false;
        }
        return this.powers[0].isOne();
    }

    public int compareTo(PNodeI pNodeI) {
        if (pNodeI instanceof PConstant) {
            return 1;
        }
        if (pNodeI instanceof Monomial) {
            Monomial monomial = (Monomial)pNodeI;
            for (int i = 0; i < this.vars.length; ++i) {
                if (i >= monomial.vars.length) {
                    return 1;
                }
                int n = this.vars[i].compareTo(monomial.vars[i]);
                if (n != 0) {
                    return n;
                }
                n = this.powers[i].compareTo(monomial.powers[i]);
                if (n == 0) continue;
                return n;
            }
            if (this.vars.length > monomial.vars.length) {
                return 1;
            }
            if (this.vars.length < monomial.vars.length) {
                return -1;
            }
            return this.coeff.compareTo(monomial.coeff);
        }
        int n = this.vars[0].compareTo(pNodeI);
        if (n == 0) {
            n = this.powers[0].compareTo(this.pc.oneConstant);
        }
        return n;
    }

    private boolean negativePower(PNodeI pNodeI) {
        return pNodeI instanceof PConstant && ((PConstant)pNodeI).isNegative();
    }

    private void printPower(StringBuffer stringBuffer, PNodeI pNodeI) {
        if (pNodeI.isOne()) {
            return;
        }
        if (pNodeI instanceof PConstant || pNodeI instanceof PVariable || pNodeI instanceof PFunction) {
            stringBuffer.append('^');
            stringBuffer.append(((Object)pNodeI).toString());
        } else {
            stringBuffer.append("^(");
            stringBuffer.append(((Object)pNodeI).toString());
            stringBuffer.append(")");
        }
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (this.coeff.isMinusOne()) {
            stringBuffer.append('-');
        } else if (!this.coeff.isOne()) {
            stringBuffer.append(this.coeff.toString());
            bl = true;
        }
        int n2 = 0;
        for (n = 0; n < this.vars.length; ++n) {
            if (this.negativePower(this.powers[n])) {
                ++n2;
                continue;
            }
            if (bl) {
                stringBuffer.append('*');
            }
            if (this.vars[n] instanceof Polynomial) {
                stringBuffer.append('(');
                stringBuffer.append(((Object)this.vars[n]).toString());
                stringBuffer.append(')');
            } else {
                stringBuffer.append(((Object)this.vars[n]).toString());
            }
            this.printPower(stringBuffer, this.powers[n]);
            bl = true;
        }
        if (n2 > 0) {
            if (!bl) {
                stringBuffer.append('1');
            }
            if (n2 > 1) {
                stringBuffer.append("/(");
            } else {
                stringBuffer.append("/");
            }
            bl = false;
            for (n = 0; n < this.vars.length; ++n) {
                if (!this.negativePower(this.powers[n])) continue;
                if (bl) {
                    stringBuffer.append('*');
                }
                if (this.vars[n] instanceof Polynomial) {
                    stringBuffer.append('(');
                    stringBuffer.append(((Object)this.vars[n]).toString());
                    stringBuffer.append(')');
                } else {
                    stringBuffer.append(((Object)this.vars[n]).toString());
                }
                try {
                    this.printPower(stringBuffer, this.powers[n].negate());
                }
                catch (ParseException parseException) {
                    throw new IllegalStateException(parseException.getMessage());
                }
                bl = true;
            }
            if (n2 > 1) {
                stringBuffer.append(")");
            }
        }
        return stringBuffer.toString();
    }

    public Node toNode() throws ParseException {
        int n = this.coeff.isOne() ? 0 : 1;
        int n2 = 0;
        for (int i = 0; i < this.vars.length; ++i) {
            if (!this.negativePower(this.powers[i])) continue;
            ++n2;
        }
        Node[] nodeArray = new Node[n + this.vars.length - n2];
        int n3 = 0;
        if (n > 0) {
            nodeArray[n3++] = this.coeff.toNode();
        }
        for (int i = 0; i < this.vars.length; ++i) {
            if (this.negativePower(this.powers[i])) continue;
            nodeArray[n3++] = this.powers[i].isOne() ? this.vars[i].toNode() : this.pc.nf.buildOperatorNode(this.pc.os.getPower(), this.vars[i].toNode(), this.powers[i].toNode());
        }
        Object object = nodeArray.length == 0 ? this.coeff.toNode() : (nodeArray.length == 1 ? nodeArray[0] : this.pc.nf.buildOperatorNode(this.pc.os.getMultiply(), nodeArray));
        if (n2 == 0) {
            return object;
        }
        Node[] nodeArray2 = new Node[n2];
        n3 = 0;
        for (int i = 0; i < this.vars.length; ++i) {
            if (!this.negativePower(this.powers[i])) continue;
            PNodeI pNodeI = this.powers[i].negate();
            nodeArray2[n3++] = this.powers[i] instanceof PConstant && ((PConstant)this.powers[i]).isMinusOne() ? this.vars[i].toNode() : this.pc.nf.buildOperatorNode(this.pc.os.getPower(), this.vars[i].toNode(), pNodeI.toNode());
        }
        Object object2 = nodeArray2.length == 1 ? nodeArray2[0] : this.pc.nf.buildOperatorNode(this.pc.os.getMultiply(), nodeArray2);
        return this.pc.nf.buildOperatorNode(this.pc.os.getDivide(), (Node)object, (Node)object2);
    }

    boolean negativeCoefficient() {
        return this.coeff.isNegative();
    }

    public PNodeI expand() throws ParseException {
        MutiablePolynomial mutiablePolynomial = new MutiablePolynomial(this.pc, new PNodeI[]{this.coeff});
        for (int i = 0; i < this.vars.length; ++i) {
            if (this.powers[i] instanceof PConstant) {
                PConstant pConstant = (PConstant)this.powers[i];
                if (pConstant.isZero()) continue;
                if (pConstant.isOne()) {
                    mutiablePolynomial.expandMul(this.vars[i].expand());
                    continue;
                }
                if (!pConstant.isInteger()) continue;
                int n = pConstant.intValue();
                if (n > 0) {
                    PNodeI pNodeI = this.vars[i].expand();
                    for (int j = 1; j <= n; ++j) {
                        mutiablePolynomial.expandMul(pNodeI);
                    }
                    continue;
                }
                mutiablePolynomial.expandMul(new Monomial(this.pc, this.pc.oneConstant, this.vars[i].expand(), this.powers[i]));
                continue;
            }
            mutiablePolynomial.expandMul(new Monomial(this.pc, this.pc.oneConstant, this.vars[i].expand(), this.powers[i]));
        }
        return mutiablePolynomial.toPNode();
    }
}

